<?php

function img2array($imgname) {
	$im = @imagecreatefromgif($imgname);
	
	$imrgb = array();
	$x = imagesx($im);
	$y = imagesy($im);
	
	for ($i=0;$i<$x;$i++) {
		for ($j=0;$j<$y;$j++) {
			$rgb = imagecolorat($im, $i, $j);
			$colors = imagecolorsforindex($im, $rgb);
			$imrgb[$i][$j] = $colors;
		}
	}
	
	imagedestroy($im);
	
	return $imrgb;
}

function draw($array) {
	$x = count($array);
	if ($x < 0)
		return;
	$y = count($array[0]);
	$newim = imagecreatetruecolor($x, $y);
	
	for ($i=0;$i<$x;$i++) {
		for ($j=0;$j<$y;$j++) {
			$colors = $array[$i][$j];
			$newcolor = imagecolorallocate($newim, $colors["red"], $colors["green"], $colors["blue"]);
			imagesetpixel($newim,$i,$j,$newcolor);
		}
	}
	
	header('Content-Type: image/gif');
	imagegif($newim);
	
	imagedestroy($newim);
}

?>