// initialize X and Y, which contains values for x and y respectively
X = 1:8;
Y = [3.6 3.7 7.8 7.6 10.3 14.0 14.6 18.1];

// use reglin() to find a and b for Y = ax+b
[a b sig] = reglin(X, Y);

// plot the equation
plot(X, Y, '.r')

[m n] = size(X);
X_lin = [X(1) X(n)];

Z = a*X_lin+b;
plot(X_lin, Z, '-b');

// find r
mean_X = mean(X);
mean_Y = mean(Y);
sum_diff_XY = sum((X-mean_X).*(Y-mean_Y));
sum_diff_Xsq = sum((X-mean_X).^2);
sum_diff_Ysq = sum((Y-mean_Y).^2);
r = sum_diff_XY/(sqroot(sum_diff_Xsq*sum_diff_Ysq));
disp("r = ");
disp(r);

// project Y at x = 9
z = a*9+b;
disp("At x = 9, y =");
disp(z);
